require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

MakeDialog
{
    Window
    {
        x=0,y=0,w=800,h=600,
        Bitmap
        {
            name="helppanel1",
            image="ui/surfaces/fullscreendialog",
            x=0,y=0,w=800,h=600,

			SetStyle(CreateTextStyle(FontGame, 32, RedColor)),
			Text
			{
				x=kCenter,y=10,w=kMax,h=40,
				flags = kVAlignCenter + kHAlignCenter,
				name = "helptitle",
				label= "helptitle",
			},

            --SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
            --CreateText(0, kCenter + 280, "#"..GetString("version",GetConfig(kGameVersion)), 0, 0),

            --Serving customers
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0201",
                x = 60, y = 50,
                w=160,h=40,
            },

            --Review the customers word...
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0201",
                x = 50, y = 85,
                w=180,h=100,
            },
            
            Bitmap
            {
				image="help/food",
				x=40,y=185,
            },

            --Remember some ingredients...
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0202",
                x = 270, y = 85,
                w=310,h=120,
            },
            
            Bitmap
            {
				image="help/ingredients",
				x=590,y=30,
            },

            --Sometimes you need to put two...
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0203",
                x = 75, y = 245,
                w=210,h=120,
            },
            
            Bitmap
            {
				image="help/ingredients_on_plate",
				x=280,y=240,
            },

			--Click on the customer to deliver the order.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0204",
                x = 430, y = 240,
                w=140,h=120,
            },
            
            Bitmap
            {
				image="help/click",
				x=550,y=250,
            },
            
            --Cash Out
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0202",
                x = 120, y = 370,
                w=100,h=40,
            },
            
            --Click on a customer who is finished eating to cash him out.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0205",
                x = 40, y = 400,
                w=160,h=120,
            },
            
            Bitmap
            {
				image="help/cash",
				x=190,y=405,
            },
            
            --Clearing Dishes
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0203",
                x = 440, y = 370,
                w=140,h=40,
            },
            
            --Click on a dirty dish to pick it up. Then click on the dish bin to drop it off.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0206",
                x = 380, y = 400,
                w=200,h=120,
            },
            
            Bitmap
            {
				image="help/trash",
				x=570,y=405,
            },
            
            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="prev",
                align=kHAlignLeft+kVAlignBottom,
                x=40,y=kMax-10,
                command=
                    function()
                        SwapToModal("scripts/help1.lua");
                    end,
		        SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
		        CreateText(2,2,"prev", 0, 0),
		        SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
		        CreateText(0,0,"prev", 0, 0),
            },
            
            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="next",
                align=kHAlignRight+kVAlignBottom,
                x=kMax-40,y=kMax-10,
                command=function()
					SwapToModal("scripts/help3.lua");
				end,
		        SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
		        CreateText(2,2,"next", 0, 0),
		        SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
		        CreateText(0,0,"next", 0, 0),
            }
        },
    },
}

